/*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 25 12:09:38 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_SEP_ATP_SpecialDataOpHMAC.c#1:csrc:1
   *  \author TaniaM
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/
#include "stdio.h"
#include "SST_SEP_TST.h"
#include "CRYS_SST.h"
#include "SEP_ATP_UTIL_funcs.h"

extern TST_ATP_SpecialDataOpHMACTestDataStruct* TST_ATP_SpecialDataOpHMACTestData;
/*****************************************************************************
 * Function Name:
 *  SEPQA_SST_SpecialDataOpHMAC
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * Test the Test the insertion, generation, reading, deletion, and usage of a HMAC key.
 *  
 * Algorithm:       
 *    1.  Create a new session by calling: SST_SessionCreate.
 *    2.  Open a transaction by calling: SST_TransactionStart.
 *    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
 *    4.  Close the transaction by calling: SST_TransactionClose.
 *    5.  Open the authenticator by calling: SST_AuthenticationOpen.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Create a new HMAC #1 key by calling: SST_HMACKeyGenerate.
 *    8.  Read the generated HMAC key #1 by calling: SST_HMACKeyRead.
 *    9.  Insert a HMAC #2 key to the SST by calling: SST_HMACKeyInsert. Using the data received by reading the SST key #1
 *    10.  Read the inserted HMAC key #2 by calling: SST_HMACKeyRead. And compare to data used.
 *    11.  Close the transaction by calling: SST_TransactionEnd.
 *    12.  Hash plain text by using HMAC key #1 and calling: CRYS_SST_HMAC.
 *    13.  Hash the received cipher text using HMAC key #2 by calling: CRYS_SST_HMAC and compare to the original hash result.
 *    14.  Open a transaction by calling: SST_TransactionStart.
 *    15.  Delete the HMAC keys (one by one) by calling: SST_DataDelete.
 *    16.  Close the authenticator by calling: SST_AuthenticationClose.
 *    17.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    18.  Close the transaction by calling: SST_TransactionClose.
 *    19.  Delete the session by calling: SST_SessionDelete.
 *******************************************************************************/
DxError_t SEPQA_SST_SpecialDataOpHMAC ( void )
{ 
   /********* TST Variables Definitions ************/
    DxUint32_t                  TST_index=0;
    DxChar                      TST_MasterTestName[TST_FUNC_STRING_LEN] = "SEPQA_SST_SpecialDataOpHMAC";
    SSTSessionId_t              TST_SessionId; 
    SSTTxnId_t                  TST_TransactionId;
    SSTHandle_t                 TST_AuthHandle,TST_HMACKeyHandle1,TST_HMACKeyHandle2;
    SSTDataType_t               TST_HMACKeyData = TST_HMACKEY_OBJECT;
    SSTHandle_t                 TST_AuthDefaultHandle;
    DxError_t                   TST_Status;

    /********* TST Variables initialization *********/
    TST_Status = TESTPASS;
    TST_AuthHandle.objId = SST_HANDLE_RANDOM_GENERATE;
    TST_HMACKeyHandle1.objId = SST_HANDLE_RANDOM_GENERATE;
    TST_HMACKeyHandle2.objId = SST_HANDLE_RANDOM_GENERATE;

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ************** SEPQA_SST_SpecialDataOpHMAC Tests ***************** \n"));     
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n \n"));

    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));


    /* Create a session for operations */
    /*---------------------------------*/
    TST_Status = SST_SessionCreate(&TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                        TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                        TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Create a new password authenticator */
    /*-------------------------------------*/
    TST_AuthDefaultHandle.objDigest = 0;
    TST_AuthDefaultHandle.objId = SST_CLOSE_AUTH_HANDLE;

    TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                TST_SessionId,
                                                TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Password,
                                                TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_PasswordSizeInBytes,
                                                TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_MaxNumOfTrials,
                                                TST_AuthDefaultHandle,
                                                &TST_AuthHandle,
                                                TST_Workspace,
                                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate",
                        TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                        TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Open the password authentication */
    /*----------------------------------*/
        TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                            TST_AuthHandle,
                                            TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Password,
                                            TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_PasswordSizeInBytes,
                                            TST_NO_CHALLENGE,
                                            TST_Workspace,
                                            TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Create a new HMAC key #1 */
    /*-------------------------*/
    TST_Status = SST_HMACKeyGenerate(TST_TransactionId,
                                     TST_SessionId,
                                     TST_AuthHandle,
                                     TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKey1Size,
                                     TST_HMACKeyData,
                                     &TST_HMACKeyHandle1,
                                     TST_Workspace,
                                     TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_HMACKeyGenerate",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Read HMAC key #1 */
    /*-----------------*/
    TST_Status = SST_HMACKeyRead(TST_SessionId,
                                 TST_HMACKeyHandle1,
                                 TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKey2,
                                 &TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKey2Size,
                                 TST_Workspace,
                                 TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_HMACKeyRead #1",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Insert HMAC Key #2 */
    /*--------------------*/
    TST_Status = SST_HMACKeyInsert(TST_TransactionId,
                                   TST_SessionId,
                                   TST_AuthHandle,
                                   TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKey2,
                                   TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKey2Size,
                                   TST_HMACKeyData,
                                   &TST_HMACKeyHandle2,
                                   TST_Workspace,
                                   TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_HMACKeyInsert - Key #2",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Read HMAC key #2 */
    /*-----------------*/
    TST_Status = SST_HMACKeyRead(TST_SessionId,
                                 TST_HMACKeyHandle2,
                                 TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKeyTemp,
                                 &TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKeyTempSize,
                                 TST_Workspace,
                                 TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_HMACKeyRead #2",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Compare the retrieved key to inserted one */
    /*-------------------------------------------*/
    if(TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKey2Size ==
        TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKeyTempSize)
        TST_Status = TESTPASS; /*Data Buffers are the same*/
    else
        TST_Status = TESTFAIL; /*Data Buffers are different*/

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Compare key size - HMACKey2",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    if(!DX_VOS_MemCmp(TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKey2,
                      TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKeyTemp,
                      TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKeyTempSize))
        TST_Status = TESTPASS; /*Data Buffers are the same*/
    else
        TST_Status = TESTFAIL; /*Data Buffers are different*/

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - keys",
                        TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                        TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* HASH a block of data using key #1 */
    /*-----------------------------------*/
    TST_Status = CRYS_SST_HMAC(TST_HMACKeyHandle1,
                               TST_SessionId,
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_OperationMode,
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_DataIn,
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_DataInSize,
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_DataHMAC_Result1,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_HMAC - Key1",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* HASH a block of data using key #2 */
    /*-----------------------------------*/
    TST_Status = CRYS_SST_HMAC(TST_HMACKeyHandle2,
                               TST_SessionId,
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_OperationMode,
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_DataIn,
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_DataInSize,
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_DataHMAC_Result2,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_HMAC - Key2",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Compare the hashed results */
    /*----------------------------*/
    if(!DX_VOS_MemCmp(TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_DataHMAC_Result1,
                      TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_DataHMAC_Result2,
                      TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HASHSize))
        TST_Status = TESTPASS; /*Data Buffers are the same*/
    else
        TST_Status = TESTFAIL; /*Data Buffers are different*/

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Decrypted data",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Delete the HMAC keys */
    /*---------------------*/
    TST_Status = SST_DataDelete(TST_TransactionId,
                                TST_SessionId,
                                TST_HMACKeyHandle1,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - HMAC key #1",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    TST_Status = SST_DataDelete(TST_TransactionId,
                                TST_SessionId,
                                TST_HMACKeyHandle2,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - HMAC key #2",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Close the authentication */
    /*--------------------------*/
    TST_Status = SST_AuthenticationClose(TST_SessionId,TST_AuthHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Delete the authenticator */
    /*--------------------------*/
    TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                         TST_AuthHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Delete the session */
    /*--------------------*/
    TST_Status = SST_SessionDelete(TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                               TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                               TST_MasterTestName);




  EXIT_ON_ERROR:

    return TST_Status;

}/* End of SST_TST_ATP_SpecialDataOpHMAC */

